/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.MixtureModel;
import jMEF.Parameter;

public class Clustering {
    public static Parameter getCenterOfMass(MixtureModel f) {
        Parameter centroid = f.param[0].Times(f.weight[0]);
        double sum = f.weight[0];
        int i = 1;
        while (i < f.size) {
            centroid = centroid.Plus(f.param[i].Times(f.weight[i]));
            sum += f.weight[i];
            ++i;
        }
        return centroid.Times(1.0 / sum);
    }

    public static Parameter getGeneralizedCentroid(ExponentialFamily EF, MixtureModel f) {
        Parameter centroid = EF.gradF(f.param[0]).Times(f.weight[0]);
        double sum = f.weight[0];
        int i = 1;
        while (i < f.size) {
            centroid = centroid.Plus(EF.gradF(f.param[i]).Times(f.weight[i]));
            sum += f.weight[i];
            ++i;
        }
        return EF.gradG(centroid.Times(1.0 / sum));
    }

    public static Parameter getSymmetricCentroid(ExponentialFamily EF, MixtureModel f) {
        double l;
        Parameter thetaR = Clustering.getCenterOfMass(f);
        Parameter thetaL = Clustering.getGeneralizedCentroid(EF, f);
        double lmin = 0.0;
        double lmax = 1.0;
        while (lmax - lmin > 1.0E-6) {
            l = (lmin + lmax) / 2.0;
            Parameter thetageodesic = EF.GeodesicPoint(thetaR, thetaL, l);
            if (EF.BD(thetageodesic, thetaR) > EF.BD(thetaL, thetageodesic)) {
                lmax = l;
                continue;
            }
            lmin = l;
        }
        l = (lmin + lmax) / 2.0;
        Parameter centroid = EF.GeodesicPoint(thetaR, thetaL, l);
        return centroid;
    }

    public static Parameter getCentroid(MixtureModel f, CLUSTERING_TYPE type) {
        Parameter centroid = type == CLUSTERING_TYPE.RIGHT_SIDED ? Clustering.getCenterOfMass(f) : (type == CLUSTERING_TYPE.LEFT_SIDED ? Clustering.getGeneralizedCentroid(f.EF, f) : Clustering.getSymmetricCentroid(f.EF, f));
        return centroid;
    }

    public static enum CLUSTERING_TYPE {
        LEFT_SIDED,
        RIGHT_SIDED,
        SYMMETRIC;

    }
}

