/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.MixtureModel;
import jMEF.PVector;
import jMEF.Parameter;
import java.util.Vector;

public class BregmanSoftClustering {
    private static int MAX_ITERATIONS = 30;

    public static MixtureModel initialize(Vector<PVector>[] clusters, ExponentialFamily EF) {
        MixtureModel mm = new MixtureModel(clusters.length);
        mm.EF = EF;
        int nb = 0;
        int i = 0;
        while (i < clusters.length) {
            nb += clusters[i].size();
            ++i;
        }
        i = 0;
        while (i < clusters.length) {
            mm.weight[i] = (double)clusters[i].size() / (double)nb;
            Object param = EF.t((Parameter)clusters[i].get(0));
            int j = 1;
            while (j < clusters[i].size()) {
                param = ((Parameter)param).Plus((Parameter)mm.EF.t(clusters[i].get(j)));
                ++j;
            }
            param = ((Parameter)param).Times(1.0 / (double)clusters[i].size());
            mm.param[i] = mm.EF.Eta2Lambda(param);
            ++i;
        }
        return mm;
    }

    public static MixtureModel run(PVector[] pointSet, MixtureModel fL, int iterations) {
        MAX_ITERATIONS = iterations;
        return BregmanSoftClustering.run(pointSet, fL);
    }

    public static MixtureModel run(PVector[] pointSet, MixtureModel fL) {
        double logLikelihoodOld;
        int n = fL.size;
        int m = pointSet.length;
        int iterations = 0;
        MixtureModel fH = BregmanSoftClustering.mixtureL2H(fL);
        double logLikelihoodNew = BregmanSoftClustering.logLikelihood(pointSet, fH);
        double logLikelihoodThreshold = Math.abs(logLikelihoodNew) * 0.01;
        do {
            int col;
            double sum;
            logLikelihoodOld = logLikelihoodNew;
            double[][] p = new double[m][n];
            int row = 0;
            while (row < m) {
                sum = 0.0;
                col = 0;
                while (col < n) {
                    double tmp;
                    p[row][col] = tmp = fH.weight[col] * Math.exp(fL.EF.G(fH.param[col]) + ((Parameter)fL.EF.t(pointSet[row])).Minus(fH.param[col]).InnerProduct(fL.EF.gradG(fH.param[col])));
                    sum += tmp;
                    ++col;
                }
                col = 0;
                while (col < n) {
                    double[] dArray = p[row];
                    int n2 = col++;
                    dArray[n2] = dArray[n2] / sum;
                }
                ++row;
            }
            col = 0;
            while (col < n) {
                sum = p[0][col];
                fH.param[col] = ((Parameter)fL.EF.t(pointSet[0])).Times(p[0][col]);
                row = 1;
                while (row < m) {
                    sum += p[row][col];
                    fH.param[col] = fH.param[col].Plus(((Parameter)fL.EF.t(pointSet[row])).Times(p[row][col]));
                    ++row;
                }
                fH.weight[col] = sum / (double)m;
                fH.param[col] = fH.param[col].Times(1.0 / sum);
                fH.param[col].type = Parameter.TYPE.EXPECTATION_PARAMETER;
                ++col;
            }
            logLikelihoodNew = BregmanSoftClustering.logLikelihood(pointSet, fH);
        } while (++iterations < MAX_ITERATIONS && Math.abs(logLikelihoodOld - logLikelihoodNew) > logLikelihoodThreshold);
        return BregmanSoftClustering.mixtureH2L(fH);
    }

    private static MixtureModel mixtureL2H(MixtureModel fL) {
        int size = fL.size;
        MixtureModel fH = new MixtureModel(size);
        fH.EF = fL.EF;
        int i = 0;
        while (i < size) {
            fH.weight[i] = fL.weight[i];
            fH.param[i] = fL.EF.Theta2Eta(fL.EF.Lambda2Theta(fL.param[i]));
            ++i;
        }
        return fH;
    }

    private static MixtureModel mixtureH2L(MixtureModel fH) {
        int size = fH.size;
        MixtureModel fL = new MixtureModel(size);
        fL.EF = fH.EF;
        int i = 0;
        while (i < size) {
            fL.weight[i] = fH.weight[i];
            fL.param[i] = fH.EF.Theta2Lambda(fH.EF.Eta2Theta(fH.param[i]));
            ++i;
        }
        return fL;
    }

    private static double logLikelihood(PVector[] points, MixtureModel f) {
        double value = 0.0;
        int i = 0;
        while (i < points.length) {
            value += Math.log(f.density(points[i]));
            ++i;
        }
        return value;
    }
}

