/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.Clustering;
import jMEF.HierarchicalMixtureModel;
import jMEF.MixtureModel;
import jMEF.Parameter;

public class BregmanHierarchicalClustering {
    public static HierarchicalMixtureModel build(MixtureModel f, Clustering.CLUSTERING_TYPE type, LINKAGE_CRITERION linkage) {
        int n = f.size;
        MixtureModel fT = BregmanHierarchicalClustering.mixtureL2T(f);
        HierarchicalMixtureModel[] hmm_array = new HierarchicalMixtureModel[n];
        int i = 0;
        while (i < n) {
            MixtureModel mm = new MixtureModel(1);
            mm.EF = fT.EF;
            mm.param[0] = fT.param[i];
            mm.weight[0] = 1.0;
            HierarchicalMixtureModel hmm = new HierarchicalMixtureModel();
            hmm.EF = fT.EF;
            hmm.weight = fT.weight[i];
            hmm.node = mm;
            hmm.type = type;
            hmm.resolutionMax = 1;
            hmm_array[i] = hmm;
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            HierarchicalMixtureModel[] hmm_array_new = new HierarchicalMixtureModel[n - i - 1];
            int[] index = BregmanHierarchicalClustering.find2ClosestMixtureModels(hmm_array, type, linkage);
            HierarchicalMixtureModel hmm_1 = hmm_array[index[0]];
            HierarchicalMixtureModel hmm_2 = hmm_array[index[1]];
            MixtureModel mm_1 = hmm_1.node;
            MixtureModel mm_2 = hmm_2.node;
            MixtureModel mm = new MixtureModel(mm_1.size + mm_2.size);
            mm.EF = mm_1.EF;
            int j = 0;
            while (j < mm_1.size) {
                mm.param[j] = mm_1.param[j];
                mm.weight[j] = mm_1.weight[j] * hmm_1.weight;
                ++j;
            }
            j = 0;
            while (j < mm_2.size) {
                mm.param[mm_1.size + j] = mm_2.param[j];
                mm.weight[mm_1.size + j] = mm_2.weight[j] * hmm_2.weight;
                ++j;
            }
            mm.normalizeWeights();
            HierarchicalMixtureModel hmm = new HierarchicalMixtureModel();
            hmm.EF = mm_1.EF;
            hmm.weight = hmm_1.weight + hmm_2.weight;
            hmm.node = mm;
            hmm.leftChild = hmm_1;
            hmm.rightChild = hmm_2;
            hmm.type = hmm_1.type;
            hmm.resolutionMax = hmm_1.resolutionMax + 1;
            hmm_1.parent = hmm;
            hmm_2.parent = hmm;
            hmm_array_new[0] = hmm;
            int cpt = 1;
            j = 0;
            while (j < n - i) {
                if (j != index[0] && j != index[1]) {
                    HierarchicalMixtureModel hmm_current = hmm_array[j];
                    HierarchicalMixtureModel hmm_new = new HierarchicalMixtureModel();
                    hmm_new.EF = hmm_current.EF;
                    hmm_new.node = hmm_current.node;
                    hmm_new.weight = hmm_current.weight;
                    hmm_new.leftChild = hmm_current;
                    hmm_new.type = hmm_current.type;
                    hmm_new.resolutionMax = hmm_current.resolutionMax + 1;
                    hmm_current.parent = hmm_new;
                    hmm_array_new[cpt] = hmm_new;
                    ++cpt;
                }
                ++j;
            }
            hmm_array = hmm_array_new;
            ++i;
        }
        return hmm_array[0];
    }

    private static int[] find2ClosestMixtureModels(HierarchicalMixtureModel[] hmmArray, Clustering.CLUSTERING_TYPE type, LINKAGE_CRITERION linkage) {
        int[] index = new int[2];
        int n = hmmArray.length;
        double dmin = Double.MAX_VALUE;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (i != j) {
                    MixtureModel mm1 = hmmArray[i].node;
                    MixtureModel mm2 = hmmArray[j].node;
                    double d = Double.MAX_VALUE;
                    if (linkage == LINKAGE_CRITERION.MINIMUM_DISTANCE) {
                        d = BregmanHierarchicalClustering.computeMinDistance(mm1, mm2, type) * hmmArray[i].weight * hmmArray[j].weight;
                    } else if (linkage == LINKAGE_CRITERION.MAXIMUM_DISTANCE) {
                        d = BregmanHierarchicalClustering.computeMaxDistance(mm1, mm2, type) * hmmArray[i].weight * hmmArray[j].weight;
                    } else if (linkage == LINKAGE_CRITERION.AVERAGE_DISTANCE) {
                        d = BregmanHierarchicalClustering.computeAverageDistance(mm1, mm2, type) * hmmArray[i].weight * hmmArray[j].weight;
                    }
                    if (d < dmin) {
                        index[0] = i;
                        index[1] = j;
                        dmin = d;
                    }
                }
                ++j;
            }
            ++i;
        }
        return index;
    }

    private static double computeMinDistance(MixtureModel mm1, MixtureModel mm2, Clustering.CLUSTERING_TYPE type) {
        double d = Double.MAX_VALUE;
        int i = 0;
        while (i < mm1.size) {
            int j = 0;
            while (j < mm2.size) {
                double tmp = 0.0;
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    tmp = mm1.EF.BD(mm1.param[i], mm2.param[j]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    tmp = mm1.EF.BD(mm2.param[j], mm1.param[i]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    tmp = 0.5 * (mm1.EF.BD(mm1.param[i], mm2.param[j]) + mm1.EF.BD(mm2.param[j], mm1.param[i])) * mm1.weight[i] * mm2.weight[j];
                }
                d = Math.min(d, tmp);
                ++j;
            }
            ++i;
        }
        return d;
    }

    private static double computeMaxDistance(MixtureModel mm1, MixtureModel mm2, Clustering.CLUSTERING_TYPE type) {
        double d = 0.0;
        int i = 0;
        while (i < mm1.size) {
            int j = 0;
            while (j < mm2.size) {
                double tmp = 0.0;
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    tmp = mm1.EF.BD(mm1.param[i], mm2.param[j]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    tmp = mm1.EF.BD(mm2.param[j], mm1.param[i]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    tmp = 0.5 * (mm1.EF.BD(mm1.param[i], mm2.param[j]) + mm1.EF.BD(mm2.param[j], mm1.param[i])) * mm1.weight[i] * mm2.weight[j];
                }
                d = Math.max(d, tmp);
                ++j;
            }
            ++i;
        }
        return d;
    }

    private static double computeAverageDistance(MixtureModel mm1, MixtureModel mm2, Clustering.CLUSTERING_TYPE type) {
        double d = 0.0;
        int i = 0;
        while (i < mm1.size) {
            int j = 0;
            while (j < mm2.size) {
                double tmp = 0.0;
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    tmp = mm1.EF.BD(mm1.param[i], mm2.param[j]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    tmp = mm1.EF.BD(mm2.param[j], mm1.param[i]) * mm1.weight[i] * mm2.weight[j];
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    tmp = 0.5 * (mm1.EF.BD(mm1.param[i], mm2.param[j]) + mm1.EF.BD(mm2.param[j], mm1.param[i])) * mm1.weight[i] * mm2.weight[j];
                }
                d += tmp;
                ++j;
            }
            ++i;
        }
        return d / (double)(mm1.size * mm2.size);
    }

    private static MixtureModel mixtureL2T(MixtureModel fLambda) {
        int size = fLambda.size;
        MixtureModel fTheta = new MixtureModel(size);
        fTheta.EF = fLambda.EF;
        int i = 0;
        while (i < size) {
            fTheta.weight[i] = fLambda.weight[i];
            fTheta.param[i] = fLambda.EF.Lambda2Theta(fLambda.param[i]);
            fTheta.param[i].type = Parameter.TYPE.NATURAL_PARAMETER;
            ++i;
        }
        return fTheta;
    }

    public static enum LINKAGE_CRITERION {
        MINIMUM_DISTANCE,
        MAXIMUM_DISTANCE,
        AVERAGE_DISTANCE;

    }
}

