/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.Clustering;
import jMEF.MixtureModel;
import jMEF.Parameter;
import jMEF.Quicksort;
import java.util.Arrays;
import java.util.Random;

public class BregmanHardClustering {
    private static int MAX_ITERATIONS = 30;

    public static MixtureModel simplify(MixtureModel f, int m, Clustering.CLUSTERING_TYPE type, int iterations) {
        MAX_ITERATIONS = iterations;
        return BregmanHardClustering.simplify(f, m, type);
    }

    public static MixtureModel simplify(MixtureModel f, int m, Clustering.CLUSTERING_TYPE type) {
        MixtureModel fT = BregmanHardClustering.mixtureL2T(f);
        MixtureModel gT = BregmanHardClustering.initialize(fT, m, type);
        int[] repartition = new int[fT.size];
        BregmanHardClustering.batchKMeans(fT, gT, type, repartition);
        return BregmanHardClustering.mixtureT2L(gT);
    }

    public static MixtureModel simplify(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type) {
        MixtureModel fT = BregmanHardClustering.mixtureL2T(f);
        MixtureModel gT = BregmanHardClustering.mixtureL2T(g);
        int[] repartition = new int[fT.size];
        BregmanHardClustering.batchKMeans(fT, gT, type, repartition);
        return BregmanHardClustering.mixtureT2L(gT);
    }

    private static MixtureModel mixtureL2T(MixtureModel fL) {
        int size = fL.size;
        MixtureModel fTheta = new MixtureModel(size);
        fTheta.EF = fL.EF;
        int i = 0;
        while (i < size) {
            fTheta.weight[i] = fL.weight[i];
            fTheta.param[i] = fL.EF.Lambda2Theta(fL.param[i]);
            fTheta.param[i].type = Parameter.TYPE.NATURAL_PARAMETER;
            ++i;
        }
        return fTheta;
    }

    private static MixtureModel mixtureT2L(MixtureModel fT) {
        int size = fT.size;
        MixtureModel fLambda = new MixtureModel(size);
        fLambda.EF = fT.EF;
        int i = 0;
        while (i < size) {
            fLambda.weight[i] = fT.weight[i];
            fLambda.param[i] = fT.EF.Theta2Lambda(fT.param[i]);
            fLambda.param[i].type = Parameter.TYPE.SOURCE_PARAMETER;
            ++i;
        }
        return fLambda;
    }

    private static MixtureModel initialize2(MixtureModel f, int m) {
        MixtureModel g = new MixtureModel(m);
        g.EF = f.EF;
        int i = 0;
        while (i < m) {
            g.weight[i] = f.weight[i];
            g.param[i] = f.param[i];
            g.param[i].type = f.param[i].type;
            ++i;
        }
        g.normalizeWeights();
        return g;
    }

    private static MixtureModel initialize(MixtureModel f, int m, Clustering.CLUSTERING_TYPE type) {
        int n = f.size;
        MixtureModel g = new MixtureModel(m);
        g.EF = f.EF;
        Random rand = new Random();
        double[][] kld_mat = new double[m][n];
        int[] gau = new int[n];
        int i = 0;
        while (i < n) {
            gau[i] = 0;
            ++i;
        }
        int index = rand.nextInt(n);
        g.weight[0] = f.weight[index];
        g.param[0] = f.param[index];
        gau[index] = 1;
        i = 0;
        while (i < n) {
            if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                kld_mat[0][i] = f.EF.BD(f.param[i], g.param[0]);
            } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                kld_mat[0][i] = f.EF.BD(g.param[0], f.param[i]);
            } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                kld_mat[0][i] = 0.5 * (f.EF.BD(f.param[i], g.param[0]) + f.EF.BD(g.param[0], f.param[i]));
            }
            ++i;
        }
        int row = 1;
        while (row < m) {
            double[] kld_min = new double[n];
            int[] idx = new int[n];
            i = 0;
            while (i < n) {
                double min = Double.MAX_VALUE;
                int j = 0;
                while (j < row) {
                    min = Math.min(min, kld_mat[j][i]);
                    ++j;
                }
                kld_min[i] = min;
                idx[i] = i;
                ++i;
            }
            Quicksort.quicksort(kld_min, idx);
            double[] kld_cdf = new double[n];
            double cdf = 0.0;
            i = 0;
            while (i < n) {
                kld_cdf[i] = cdf += kld_min[i];
                ++i;
            }
            double cdf_min = 0.0;
            i = 0;
            while (i < n) {
                if (kld_cdf[i] > 0.0) {
                    cdf_min = kld_cdf[i];
                    break;
                }
                ++i;
            }
            double value = rand.nextDouble() * (kld_cdf[n - 1] - cdf_min) + cdf_min;
            index = -1;
            i = 0;
            while (i < n) {
                if (gau[idx[i]] == 0 && (kld_cdf[i] < value || index == -1)) {
                    index = idx[i];
                } else if (kld_cdf[i] >= value) break;
                ++i;
            }
            g.weight[row] = f.weight[index];
            g.param[row] = f.param[index];
            gau[index] = 1;
            i = 0;
            while (i < n) {
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    kld_mat[row][i] = f.EF.BD(f.param[i], g.param[row]);
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    kld_mat[row][i] = f.EF.BD(g.param[row], f.param[i]);
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    kld_mat[row][i] = 0.5 * (f.EF.BD(f.param[i], g.param[row]) + f.EF.BD(g.param[row], f.param[i]));
                }
                ++i;
            }
            ++row;
        }
        g.normalizeWeights();
        return g;
    }

    private static void batchKMeans(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type, int[] repartition) {
        int[] repartition_old = new int[f.size];
        int iterations = 0;
        do {
            repartition_old = (int[])repartition.clone();
            BregmanHardClustering.computeRepartition(f, g, type, repartition);
            BregmanHardClustering.computeCentroids(f, g, type, repartition);
        } while (!Arrays.equals(repartition, repartition_old) && ++iterations < MAX_ITERATIONS);
    }

    private static boolean incrementalKMeans(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type, int[] repartition) {
        double lf_init;
        boolean cond = false;
        int iterations = 0;
        double lf_min = lf_init = BregmanHardClustering.getLossFunction(f, g, type);
        int n = f.size;
        int m = g.size;
        int[] rep_opt = new int[n];
        MixtureModel g_tmp = new MixtureModel(m);
        int[] count = new int[m];
        int i = 0;
        while (i < n) {
            int n2 = repartition[i];
            count[n2] = count[n2] + 1;
            ++i;
        }
        i = 0;
        while (i < n) {
            int[] rep_tmp = Arrays.copyOf(repartition, n);
            int cl = repartition[i];
            if (count[cl] > 1) {
                int j = 0;
                while (j < m) {
                    if (j != cl) {
                        rep_tmp[i] = j;
                        BregmanHardClustering.computeCentroids(f, g_tmp, type, rep_tmp);
                        double lf = BregmanHardClustering.getLossFunction(f, g_tmp, type);
                        if (lf < lf_min) {
                            lf_min = lf;
                            rep_opt = Arrays.copyOf(rep_tmp, n);
                            ++iterations;
                            System.out.println(lf_min);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (lf_min / lf_init < 0.98) {
            cond = true;
            i = 0;
            while (i < n) {
                repartition[i] = rep_opt[i];
                ++i;
            }
            BregmanHardClustering.computeCentroids(f, g, type, repartition);
            System.out.println("--> " + BregmanHardClustering.getLossFunction(f, g, type));
        }
        return cond;
    }

    private static void computeRepartition(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type, int[] repartition) {
        int n = f.size;
        int m = g.size;
        int i = 0;
        while (i < n) {
            int index = -1;
            double d_min = Double.MAX_VALUE;
            int j = 0;
            while (j < m) {
                double d = 0.0;
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    d = f.EF.BD(f.param[i], g.param[j]);
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    d = f.EF.BD(g.param[j], f.param[i]);
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    d = 0.5 * (f.EF.BD(f.param[i], g.param[j]) + f.EF.BD(g.param[j], f.param[i]));
                }
                if (d < d_min) {
                    d_min = d;
                    index = j;
                }
                ++j;
            }
            repartition[i] = index;
            ++i;
        }
    }

    private static void computeCentroids(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type, int[] repartition) {
        int n = f.size;
        int m = g.size;
        int[] count = new int[m];
        int i = 0;
        while (i < n) {
            int n2 = repartition[i];
            count[n2] = count[n2] + 1;
            ++i;
        }
        i = 0;
        while (i < m) {
            int j;
            if (count[i] == 0) {
                g.param[i] = null;
                g.weight[i] = 0.0;
                System.err.printf("The class %d is empty. Impossible to compute the centroid.", i);
            } else if (count[i] == 1) {
                j = 0;
                while (j < n) {
                    if (repartition[j] == i) {
                        g.param[i] = f.param[j];
                        g.weight[i] = f.weight[j];
                        break;
                    }
                    ++j;
                }
            } else {
                MixtureModel mix = new MixtureModel(count[i]);
                mix.EF = f.EF;
                int ind = 0;
                double sum = 0.0;
                j = 0;
                while (j < n) {
                    if (repartition[j] == i) {
                        mix.weight[ind] = f.weight[j];
                        mix.param[ind] = f.param[j];
                        sum += f.weight[j];
                        ++ind;
                    }
                    ++j;
                }
                mix.normalizeWeights();
                g.param[i] = Clustering.getCentroid(mix, type);
                g.weight[i] = sum;
            }
            ++i;
        }
    }

    private static double getLossFunction(MixtureModel f, MixtureModel g, Clustering.CLUSTERING_TYPE type) {
        int n = f.size;
        int m = g.size;
        double value = 0.0;
        int i = 0;
        while (i < n) {
            double min = Double.MAX_VALUE;
            int j = 0;
            while (j < m) {
                if (type == Clustering.CLUSTERING_TYPE.RIGHT_SIDED) {
                    min = f.EF.BD(f.param[i], g.param[j]);
                } else if (type == Clustering.CLUSTERING_TYPE.LEFT_SIDED) {
                    min = f.EF.BD(g.param[j], f.param[i]);
                } else if (type == Clustering.CLUSTERING_TYPE.SYMMETRIC) {
                    min = 0.5 * (f.EF.BD(f.param[i], g.param[j]) + f.EF.BD(g.param[j], f.param[i]));
                }
                ++j;
            }
            value += min;
            ++i;
        }
        return value;
    }
}

