/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public final class BinomialFixedN
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;
    private int n;

    public BinomialFixedN() {
        this.n = 100;
    }

    public BinomialFixedN(int n) {
        this.n = n;
    }

    @Override
    public double F(PVector T) {
        return (double)this.n * Math.log(1.0 + Math.exp(T.array[0])) - Math.log(this.fact(this.n));
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = new PVector(1);
        gradient.array[0] = (double)this.n * Math.exp(T.array[0]) / (1.0 + Math.exp(T.array[0]));
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return H.array[0] * Math.log(H.array[0] / ((double)this.n - H.array[0])) - (double)this.n * Math.log((double)this.n / ((double)this.n - H.array[0]));
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = new PVector(1);
        gradient.array[0] = Math.log(H.array[0] / ((double)this.n - H.array[0]));
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return -Math.log(this.fact(x.array[0]) * this.fact((double)this.n - x.array[0]));
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(1);
        T.array[0] = Math.log(L.array[0] / (1.0 - L.array[0]));
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(1);
        L.array[0] = Math.exp(T.array[0]) / (1.0 + Math.exp(T.array[0]));
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = (double)this.n * L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0] / (double)this.n;
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return this.fact(this.n) * Math.pow(param.array[0], x.array[0]) * Math.pow(1.0 - param.array[0], (double)this.n - x.array[0]) / (this.fact(x.array[0]) * this.fact((double)this.n - x.array[0]));
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    private double fact(double n) {
        double f = 1.0;
        int i = 1;
        while ((double)i <= n) {
            f *= (double)i;
            ++i;
        }
        return f;
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        int count = 0;
        int i = 0;
        while (i < this.n) {
            if (Math.random() < L.array[0]) {
                ++count;
            }
            ++i;
        }
        PVector point = new PVector(1);
        point.array[0] = count;
        return point;
    }

    @Override
    public double KLD(PVector L1, PVector L2) {
        double p1 = L1.array[0];
        double p2 = L2.array[0];
        double q1 = 1.0 - p1;
        double q2 = 1.0 - p2;
        return (double)this.n * q1 * Math.log(q1 / q2) + (double)this.n * p1 * Math.log(p1 / p2);
    }
}

