/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public final class Bernoulli
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return Math.log(1.0 + Math.exp(T.array[0]));
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = new PVector(1);
        gradient.array[0] = Math.exp(T.array[0]) / (1.0 + Math.exp(T.array[0]));
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return H.array[0] * Math.log(H.array[0] / (1.0 - H.array[0])) - Math.log(1.0 / (1.0 - H.array[0]));
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = new PVector(1);
        gradient.array[0] = Math.log(H.array[0] / (1.0 - H.array[0]));
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return 0.0;
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(1);
        T.array[0] = Math.log(L.array[0] / (1.0 - L.array[0]));
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(1);
        L.array[0] = Math.exp(T.array[0]) / (1.0 + Math.exp(T.array[0]));
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return Math.pow(param.array[0], x.array[0]) * Math.pow(1.0 - param.array[0], 1.0 - x.array[0]);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        PVector x = new PVector(1);
        x.array[0] = Math.random() < L.array[0] ? 1.0 : 0.0;
        return x;
    }

    @Override
    public double KLD(PVector L1, PVector L2) {
        double p1 = L1.array[0];
        double p2 = L2.array[0];
        double q1 = 1.0 - p1;
        double q2 = 1.0 - p2;
        return Math.log(q1 / q2) - p1 * Math.log(p2 * q1 / (p1 * q2));
    }
}

