#!/usr/bin/env python

## FILL IN WHERE IT SAYS "MISSING CODE"

## compressed sensing on noisy communication channels

import sys
import os
import math
import numpy as np
import cvxpy as cp
from math import sqrt
from amplpy import AMPL, DataFrame
import time
import bitarray
import matplotlib.pyplot as plt

################### configurable params #####################

myZero = 1e-9

# channel noise
DefaultDelta = 0.08

# encoding redundancy
DefaultRedundancy = 4

# distribution
DefaultDistribution = "normal"

# random projection
DefaultRP = True
jlleps = 0.2

#ShowPlots = True
ShowPlots = False

######################### functions #########################

# generate a componentwise Normal(0,1) matrix
def normalmatrix(m, n):
    return np.random.normal([0],[[1]],(m,n))

# generate a componentwise Uniform(0,1) matrix
def uniformmatrix01(m, n):
    return np.random.rand(m,n)

# generate a componentwise Uniform(-1,1) matrix
def uniformmatrix(m, n):
    return 2*np.random.rand(m,n)-1

def AAIeval(AA, m):
    ## check orthogonality 
    nA = AA.shape[0]
    ell2err = np.linalg.norm(np.subtract(AA, np.eye(nA))) / nA**2
    ell2errdiag = np.linalg.norm(np.subtract(np.diag(AA),np.ones(nA))) / nA
    ell1err = np.linalg.norm(np.subtract(AA, np.eye(nA)),1) / nA**2
    ell1errdiag = np.linalg.norm(np.subtract(np.diag(AA),np.ones(nA)),1) / nA
    print("  AAIeval: avg ||AA - I||_1 = ", ell1err)
    print("  AAIeval: avg ||AA - I||_2 = ", ell2err)
    print("  AAIeval: avg ||diag(AA) - diag(I)||_1 =", ell1errdiag)
    print("  AAIeval: avg ||diag(AA) - diag(I)||_2 = ", ell2errdiag)
    print("  AAIeval: ell1err/sqrt(m)={0:.4g}, ell2err={1:.4g}".format(ell1err/sqrt(m), ell2err))
    print("  AAIeval: ell1errdiag/sqrt(m)={0:.4g}, ell2errdiag={1:.4g}".format(ell1errdiag / sqrt(m), ell2errdiag))
    return(ell1err, ell1errdiag, ell2err, ell2errdiag)

def supp(x):
    S = []
    ##### MISSING CODE (copy your implementation from the costly example)
    return S

# compute the hamming distance between two strings
def hamming(a,b):
    dist = 0
    ##### MISSING CODE
    return dist

# encode a string into a list of bits
def string2bitlist(txt):
    txt = txt.encode('ascii', 'ignore')
    ba = bitarray.bitarray()
    ba.frombytes(txt)
    w = ba.tolist()
    w = [int(i) for i in w]
    return w

# decode a list of bits into a string
def bitlist2string(w):
    if not type(w) is list:
        w = list(w)
    for i in range(len(w)):
        w[i] = int(w[i])
    ret = bitarray.bitarray(w).tobytes().decode('latin-1')
    return ret

# cap vector entries to given interval: if interval is (L,U) anything <L is set to L and anything >U is set to U
def cap(v, interval):
    ##### MISSING CODE
    return v

# find mxn A, nxd Q encoding matrices with Im(A) orthog Im(Q)
def findencoding(m,n,d):
    ##### MISSING CODE
    return (A,Q)

####################### MAIN #######################

## read command line
nargs = len(sys.argv)
if nargs < 2:
    print("syntax: " + sys.argv[0] + "'sentence' [noise redundancy distrib rp jlleps]")
    print("  'sentence': a sentence to encode and decode")
    print("  noise = channel noise (error vector density), default", DefaultDelta)
    print("  encoding has length redundancy*|sentence|, default", DefaultRedundancy)
    print("  distrib = encoder distribution (uniform, normal), default", DefaultDistribution)
    print("  rp = 1 activates random projections, default", end='')
    if DefaultRP:
        print("1")
    else:
        print("0")
    print("  jlleps is the JLL epsilon if rp=1, default", jlleps)
    exit(1)

# start the clocks
wallclock0 = time.time()
#usersys0 = time.process_time()

# set up defaults
rpflag = DefaultRP
distrib = DefaultDistribution
Redundancy = DefaultRedundancy
Delta = DefaultDelta    

## read command line
s = sys.argv[1]
if nargs >= 7:
    jlleps = float(sys.argv[6])
if nargs >= 6:
    if sys.argv[5] == "1":
        rpflag = True
    else:
        rpflag = False
if nargs >= 5:
    distrib = sys.argv[4]
if nargs >= 4:
    Redundancy = float(sys.argv[3])
if nargs >= 3:
    Delta = float(sys.argv[2])
    
print("noise (Delta) =", Delta)
print("redundancy =", Redundancy)
print("distribution:", distrib)
print("random projection",)
if rpflag:
    print("on")
    print("jlleps =", jlleps)
else:
    print("off")
print("sentence:", s)

## compute the bitlist corresponding to the string
w = string2bitlist(s)

## generate A,Q such that Im(A) \bot Im(Q)
# size of the encoding matrix Q: n x d
d = len(w)
n = int(round(Redundancy * d))
# size of the matrix A: m x n
#  Im(A) orthogonal to Im(Q), i.e. dim( Im(A.T|Q) ) = n
m = n - d 
(A,Q) = findencoding(m,n,d)
print("A is {0:d} x {1:d}, Q is {2:d} x {3:d}".format(m,n,n,d))

# evaluate A
As = A / math.sqrt(m) 
AA = np.dot(As.T,As)
# evaluate orthogonality
print("checking orthogonality of A")
errs = AAIeval(AA, m)

## encode and send the string
# derive z from w
##### MISSING CODE

# generate random noise with density Delta
# noise vector xhat
##### MISSING CODE
        
# send z and receive the noisy version zbar
##### MISSING CODE

## decode the noisy string - compute the RHS in the basis pursuit LP
##### MISSING CODE
b = np.dot(A,zbar)

## random projection
if rpflag:
    # compute the size of the random projection, if it decreases
    # the number of constraints of the basis pursuit LP compute
    # a random projection matrix T and apply it to this LP
    ##### MISSING CODE
        
## formulate and solve LP
print("solving basis pursuit LP")
x = cp.Variable(n)
obj = cp.Minimize(cp.norm(x, 1))
constrs = [A*x - b == 0]
bp = cp.Problem(obj, constrs)
#result = bp.solve(solver = cp.MOSEK)
cplexopts = {}
cplexopts['lpmethod'] = 4 # select barrier alg
cplexopts['barrier.crossover'] = -1 # no crossover
result = bp.solve(solver = cp.GLPK, verbose=True, cplex_params=cplexopts)
print("  solverresult reported", result)
objfunval = bp.value
xstar = np.array(x.value)

S = supp(xhat)
T = supp(xstar)
decoderr1 = np.linalg.norm(np.subtract(xstar, xhat), 1)
decoderr2 = np.linalg.norm(np.subtract(xstar, xhat))
print("  ||xhat||_1={0:.4g}, optobjfunval={1:.4g}".format(np.linalg.norm(xhat,1), np.linalg.norm(xstar,1)))
print("  |supp(xhat)|={0:d}, ||supp(xstar)|={1:d}".format(len(S), len(T)))
print("  ||xstar - xhat||_1={0:.4g}, ||xstar - xhat||_2={1:.4g}".format(decoderr1, decoderr2))

# retrieve corresponding string
# now we retrieved the noise, so we can compute the original vector in R^n
#   from this we compute the vector in R^d with the pseudoinverse
#   then we round and cap and cast the vector back to a string sstar
##### MISSING CODE
hdist = hamming(s,sstar)
print("hamming_distance(sent,retr) =", hdist)
print("sent:", s)
print("retr:", sstar)

wallclock1 = time.time()
#usersys1 = time.process_time()
print("wallclock CPU: {0:.2f}".format(wallclock1-wallclock0))
#print("user+sys CPU: ", usersys1-usersys0)

